require( "scripts/style.lua" );



InfoFont = {
  standardFont,
  30,
  BorderColor
};

flosClosetText = 'floscloset';
if (UseMyWaiter()) then
	flosClosetText = 'mywaiter';
end

MakeDialog
{

	ScreenFade
	{
		x=0,
		y=0,
		w=kMax,
		h=kMax,
		name="screenfade"
	},
	
	Bitmap
	{
		name="pausebackground",
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = InfoFont,
			name = "gamepaused",
			x=31,y=35,w=404,h=32,
			flags = kHAlignCenter + kVAlignTop,
			label = "gamepaused"
		};
			
		
		SetStyle(StandardButtonStyle);
		Button
		{
			x=50,
			y=90,
			name="resume",
			label="resume",
			command=
				function()
					ActivatePauseClock(false);
				    PauseMusic(false);
					PauseGame(false);
					PopModal("scripts/pause.lua");
				end
		},
		
		Button
		{
			x=50,
			y=140,
			name="restart",
			label="restart",
			command=
				function()
					ActivatePauseClock(false);
					RestartLevel();
					PauseGame(false);
					PopModal("scripts/pause.lua");
				end
		},
		
		Button
		{
			x=50,
			y=190,
			name="floscloset",
			label=flosClosetText,
			command=
				function()
					ActivatePauseClock(false);
					ReleaseGameAssets();
					DoModal('scripts/floscloset.lua');
					if (CurrentlyInGame()) then						
						LoadGameAssets();
						ActivatePauseClock(true);
					end
				end
		},
		
		Button
		{
			x=240,
			y=90,
			name="help",
			label="help",
			command=
				function()
					ActivatePauseClock(false);
					ReleaseGameAssets();
					DoModal("scripts/help1.lua");
					LoadGameAssets();
					ActivatePauseClock(true);
				end
		},
		
		Button
		{
			x=240,
			y=140,
			name="options",
			label="options",
			command=
				function()
					ActivatePauseClock(false);
					DoModal("scripts/options.lua");
					ActivatePauseClock(true);
				end
		},
		
		Button
		{
			x=240,
			y=190,
			name="quit",
			label="quit",
			command=
				function()
					ShowUpsell();
					result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="quitconfirm",
							title = "",
					};

					if (result=='yes') then
						ActivatePauseClock(false);
						QuitGame(true);
						CloseAllWindows();
					end
				end
		},
		SetStyle(DefaultStyle);
	},
};
ActivatePauseClock(true);
PauseMusic(true);
SetFade(kDisableFade);
if (MultiPlayerGame(true)) then
	EnableWindow('floscloset', false);
end